      PROGRAM ASSI1
      IMPLICIT NONE
      INTEGER       DEF_CTXT
      INTEGER       NPROW, NPCOL, MYROW, MYCOL
      INTEGER       N, K, NB, INFO
      INTEGER       NLROWSN, NLCOLSN, NLCOLSK
      INTEGER       DESCA(9), DESCAC(9), DESCB(9), DESCX(9)
      INTEGER       DESCPIV(9)
      INTEGER       IASEED, IXSEED
      INTEGER       IDUM1
      EXTERNAL      NUMROC
      INTEGER       NUMROC
      EXTERNAL      PDLANGE
      DOUBLE PRECISION PDLANGE

      DOUBLE PRECISION DDUMMY(1), FNORM
      DOUBLE PRECISION, ALLOCATABLE :: A(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: B(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: X(:,:)
      DOUBLE PRECISION, ALLOCATABLE :: ACOPY(:,:)
      INTEGER, ALLOCATABLE :: IPIV(:)
      
      DOUBLE PRECISION WORK(1000)
*     ..
*     .. Define process grid, 
*     .. 1. Get default system context by BLACS_GET
*     .. 2. Initialize grid by calling BLACS_GRIDINIT. The order parameter 
*     .. doesnt matter, use 'R' or ' ' for row-major.
*     .. 3. Get process coordinates by BLACS_GRIDINFO. stored in 
*     .. MYROW and MYCOL
*     .. Here we set the number of processor rows and columns to use (used in 
*     .. the call to BLACS_GRIDINIT), be sure to match these in the
*     .. submit file later on
      NPROW = 2
      NPCOL = 2

      CALL BLACS_GET(-1, 0, DEF_CTXT)
      CALL BLACS_GRIDINIT( DEF_CTXT, 'Row-major',  NPROW, NPCOL )
      CALL BLACS_GRIDINFO( DEF_CTXT, NPROW, NPCOL, MYROW, MYCOL )



*     ..
*     .. Define the problem
*     ..
      N = 100
      K = 20
*     Blocking factor. What happens if NB => K ? 
      NB = 5

*     ..
*     .. Initialize the array descriptor for the matrix A, Acopy, B, and X 
*     .. calling DESCINIT. 
*     .. Determine the leading dimension of the local matrix by a call to 
*     .. NUMROC. The number of columns for the local matrix can also be 
*     .. calculated by a NUMROC call
*     ..

*     How many rows do I have of A, ACOPY, B and X ?
      NLROWSN = NUMROC( N, NB, MYROW, 0, NPROW ) 
*     How many columns do I have of A and ACOPY ?
      NLCOLSN = NUMROC( N, NB, MYCOL, 0, NPCOL )
*     How many columns do I have of B and X ?
      NLCOLSK = NUMROC( K, NB, MYCOL, 0, NPCOL )

      CALL DESCINIT( DESCA, N, N, NB, NB, 0, 0, DEF_CTXT, 
     $     MAX( 1, NLROWSN ),INFO )
      
      CALL DESCINIT( DESCAC, N, N, NB, NB, 0, 0, DEF_CTXT, 
     $     MAX( 1, NLROWSN ),INFO )

      CALL DESCINIT( DESCB, N, K, NB, NB, 0, 0, DEF_CTXT, 
     $     MAX( 1, NLROWSN ),INFO )

      CALL DESCINIT( DESCX, N, K, NB, NB, 0, 0, DEF_CTXT, 
     $     MAX( 1, NLROWSN ),INFO )
      

      CALL DESCINIT( DESCPIV, N + NB*NPROW, 1,
     $     NB, 1, 
     $     0, 0, DEF_CTXT, NB +
     $     NUMROC( N, NB, MYROW, 0, NPROW ) )



*     ..
*     .. Allocate the local arrays A, ACOPY using ALLOCATE
*     .. Note that you need to allocate IPIV as well, it should be able to 
*     .. hold NB + 'number of local rows of A' elements.
      
      ALLOCATE( A( ...) )
      ALLOCATE( ACOPY( ... ) )
      ALLOCATE( IPIV( ... ) )

      
      ALLOCATE( B( ... ) )
      ALLOCATE( X( ... ) )
       
*     ..
*     .. Generate the matrices by using PDMATGEN and some initial seed
*     ..  
      IASEED = 100
      IXSEED = 200

      CALL PDMATGEN( DEF_CTXT, 'R', 'N', N, N, NB, NB, A, DESCA(9), 
     $           0, 0, IASEED, 0, NLROWSN, 0, NLCOLSN, MYROW, MYCOL, 
     $           NPROW, NPCOL )
      
      CALL PDMATGEN( DEF_CTXT, 'R', 'N', N, K, NB, NB, X, DESCX(9), 
     $           0, 0, IXSEED, 0, NLROWSN, 0, NLCOLSK, MYROW, MYCOL, 
     $           NPROW, NPCOL )

*     ..
*     .. Take a copy of A using PDLACPY, store in ACOPY
*     .. This is so that you can verify the solution later on
*     ..
      CALL PDLACPY( ... TODO )      

*     ..
*     .. Compute B := A*X using PDGEMM
*     ..
      CALL PDGEMM( ... TODO )


*     ..
*     .. Copy B to X, overwriting X
*     ..
      CALL PDLACPY( ... TODO )  

*     ..
*     .. Solve A*X = B for X
*     .. 1. Compute LU of A using PDGETRF, owerwrites A
      CALL PDGETRF( ... TODO )

      

*     ..
*     .. 2. Apply the permuation to X, represented by the vector IPIV
*     .. Use the routine PDLAPIV for this
*     .. The permutation should be applied forwardwise, on rows having 
*     .. IPIV stored over column
*     .. No integer workspace should be needed
      CALL PDLAPIV( ... TODO )


*     ..
*     .. 3. Solve L*Y = X for Y overwriting X using the routine PDTRSM
*     .. Input is on left hand side and is lower triangular.
*     .. The input is not transposed, and is UNIT triangular - why ?
      CALL PDTRSM( ... TODO )

*     ..
*     .. 4. Solve U*Z = X for Z  overwriting X using the routine PDTRSM.
*     .. Input is on left hand side and is upper triangular.
*     .. Input is not transposed and is not UNIT triangular
      CALL PDTRSM( ... TODO )

*     ..
*     .. Verify the computed solution 
*     .. Compute B := ACOPY * X - B using PDGEMM
      CALL PDGEMM( ... TODO )


*     .. 
*     .. Compute the residual (Frobenius norm) of B using PDLANGE
*     .. Note that the parameter WORK is not used when computing the Frobenius
*     .. norm - just pass a dummy double precision parameter
      FNORM = PDLANGE( ... TODO )
 
*     ..
*     .. Write out the residual, and voila complete..
*     .. WRITE(*,*)'Fnorm=', FNORM
      
      WRITE(*,*)'Fnorm=', FNORM
      GOTO 20

 10   CONTINUE
      WRITE(*,*)'Some error occured. Exiting'

 20   CONTINUE
      DEALLOCATE(A)
      DEALLOCATE(ACOPY)
      DEALLOCATE(B)
      DEALLOCATE(X)
      DEALLOCATE(IPIV)
 
      CALL BLACS_GRIDEXIT(DEF_CTXT)
      CALL BLACS_EXIT(0)
      END
